/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.iw.tasks.connectivity;

import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.iw.WizardTaskBean;
import com.ibm.hsc.iw.WizardTaskException;
import com.ibm.hsc.iw.tasks.connectivity.AddEditPassthruInfo;
import com.ibm.hsc.iw.tasks.connectivity.ConnectivityConstants;
import com.ibm.hsc.iw.tasks.connectivity.ConnectivityInit;
import com.ibm.hsc.iw.tasks.connectivity.ConnectivityState;
import com.ibm.hwmca.fw.rcs.conndata.PassthruInfo;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.io.Serializable;
import java.util.List;

public class ConfigurePassThruBean
extends WizardTaskBean
implements ConnectivityConstants {
    private static final String TRACE_MASKD = "JIWZCPBD";
    private static final String TRACE_MASKF = "JIWZCPBF";
    private static final String TRACE_MASKT = "JIWZCPBT";
    private ItemDescriptor[][] m_idPassThruSystemsTable = new ItemDescriptor[0][0];
    private ColumnDescriptor[] m_cdPassThruSystemsTableStructure = new ColumnDescriptor[0];
    private int[] m_iPassThruSystemsTableSelection = new int[0];
    private List passThruSystems;
    private ConnectivityState connectivityState;

    public ConfigurePassThruBean(Object object) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->ConfigurePassThruBean()");
        }
        ConnectivityInit connectivityInit = (ConnectivityInit)object;
        this.connectivityState = connectivityInit.getConnectivityState();
        OutboundConfigData outboundConfigData = connectivityInit.getOutConfigData();
        this.setPassThruSystems(outboundConfigData.getPassthruInfo());
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--ConfigurePassThruBean()");
        }
    }

    public void setPassThruSystemsTableSelection(int[] nArray) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            if (nArray != null && nArray.length > 0) {
                Trace.trace(TRACE_MASKT, "-->setPassThruSystemsTableSelection(" + nArray[0] + ")");
            } else {
                Trace.trace(TRACE_MASKT, "-->setPassThruSystemsTableSelection(none)");
            }
        }
        this.m_iPassThruSystemsTableSelection = nArray;
        this.updateUTMElements();
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--setPassThruSystemsTableSelection()");
        }
    }

    public int[] getPassThruSystemsTableSelection() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getPassThruSystemsTableSelection()");
        }
        return this.m_iPassThruSystemsTableSelection;
    }

    public void setPassThruSystemsTableRowAt(int n, ItemDescriptor[] itemDescriptorArray) throws IllegalUserDataException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->setPassThruSystemsTableRowAt()");
        }
        this.m_idPassThruSystemsTable[n] = itemDescriptorArray;
    }

    public List getPassThruSystems() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getPassThruSystems()");
        }
        return this.passThruSystems;
    }

    public void setPassThruSystems(List list) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->setPassThruSystems(SIZE:(" + list.size() + "))");
        }
        this.passThruSystems = list;
    }

    public ItemDescriptor[] getPassThruSystemsTableRowAt(int n) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getPassThruSystemsTableRowAt(" + n + ")");
        }
        return this.m_idPassThruSystemsTable[n];
    }

    public int getPassThruSystemsTableRowCount() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getPassThruSystemsTableRowCount()");
        }
        return this.m_idPassThruSystemsTable.length;
    }

    public int getPassThruSystemsTableRowStatus() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getPassThruSystemsTableRowStatus()");
        }
        return 3;
    }

    public ColumnDescriptor[] getPassThruSystemsTableRowStructure() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->getPassThruSystemsTableRowStructure()");
        }
        return this.m_cdPassThruSystemsTableStructure;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void prepare() {
        if (Trace.LEVEL >= 2) {
            Trace.trace(TRACE_MASKF, "-->prepare()");
        }
        this.updateDataBeanInfo(true);
        this.updateUTMElements();
        if (Trace.LEVEL >= 2) {
            Trace.trace(TRACE_MASKF, "<--prepare()");
        }
    }

    public void load() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-->load()");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--load()");
        }
    }

    public void panelAction(TaskActionEvent taskActionEvent) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->panelAction() : \n\tBean Name     : " + this.getBeanName() + "\n\tCurrentElement: " + taskActionEvent.getCurrentElement() + "\n\tElementName   : " + taskActionEvent.getElementName() + "\n\tActionCommand : " + taskActionEvent.getActionCommand());
        }
        if (taskActionEvent.getElementName().equals(this.getMountPrefix() + "AddButton")) {
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Configure Passthru ADD button hit");
            }
            this.display("com.ibm.hsc.iw.tasks.connectivity.res.Connectivity", "AddPassThruSystemPanel", "com.ibm.hsc.iw.tasks.connectivity.AddPassThruSystemBean", null);
        } else if (taskActionEvent.getElementName().equals(this.getMountPrefix() + "EditButton")) {
            int[] nArray;
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Configure Passthru EDIT button hit");
            }
            if ((nArray = this.getPassThruSystemsTableSelection()).length >= 1) {
                int n = nArray[0];
                this.display("com.ibm.hsc.iw.tasks.connectivity.res.Connectivity", "EditPassThruSystemPanel", "com.ibm.hsc.iw.tasks.connectivity.EditPassThruSystemBean", (Serializable)((PassthruInfo)this.passThruSystems.get(n)));
            }
        } else if (taskActionEvent.getElementName().equals(this.getMountPrefix() + "RemoveButton")) {
            int[] nArray;
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Configure Passthru REMOVE button hit");
            }
            if ((nArray = this.getPassThruSystemsTableSelection()).length >= 1) {
                int n = nArray[0];
                this.passThruSystems.remove(n);
                this.updateDataBeanInfo(false);
                if (this.passThruSystems.size() >= 1) {
                    nArray[0] = n > 0 ? n - 1 : 0;
                } else {
                    nArray = new int[]{};
                }
                this.setPassThruSystemsTableSelection(nArray);
            }
        } else if (taskActionEvent.getElementName().equals(this.getMountPrefix() + "UpButton")) {
            int n;
            int[] nArray;
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Configure Passthru UP button hit");
            }
            if ((nArray = this.getPassThruSystemsTableSelection()).length >= 1 && (n = nArray[0]) > 0) {
                PassthruInfo passthruInfo = (PassthruInfo)this.passThruSystems.get(n - 1);
                this.passThruSystems.set(n - 1, this.passThruSystems.get(n));
                this.passThruSystems.set(n, passthruInfo);
                this.updateDataBeanInfo(false);
                nArray[0] = n - 1;
                this.setPassThruSystemsTableSelection(nArray);
            }
        } else if (taskActionEvent.getElementName().equals(this.getMountPrefix() + "DownButton")) {
            int n;
            int[] nArray;
            if (3 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Configure Passthru DOWN button hit");
            }
            if ((nArray = this.getPassThruSystemsTableSelection()).length >= 1 && (n = nArray[0]) < this.passThruSystems.size() - 1) {
                PassthruInfo passthruInfo = (PassthruInfo)this.passThruSystems.get(n + 1);
                this.passThruSystems.set(n + 1, this.passThruSystems.get(n));
                this.passThruSystems.set(n, passthruInfo);
                this.updateDataBeanInfo(false);
                nArray[0] = n + 1;
                this.setPassThruSystemsTableSelection(nArray);
            }
        } else {
            if (2 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Unknown event received in panelAction(...).");
            }
            new AusMicrocodeLog(LOG_INFO_PASSTHRU, 1, new Exception(taskActionEvent.toString())).writeEntryFromTaskletClient();
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--panelAction(...)");
        }
    }

    public void displayComplete(Serializable serializable) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-->displayComplete()");
        }
        AddEditPassthruInfo addEditPassthruInfo = (AddEditPassthruInfo)serializable;
        PassthruInfo passthruInfo = addEditPassthruInfo.getNewPassthruInfo();
        PassthruInfo passthruInfo2 = addEditPassthruInfo.getOldPassthruInfo();
        if (passthruInfo != null) {
            if (passthruInfo2 == null) {
                this.passThruSystems.add(passthruInfo);
                this.updateDataBeanInfo(false);
                this.setPassThruSystemsTableSelection(new int[]{this.passThruSystems.size() - 1});
            } else {
                int[] nArray;
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "updatedSystem=" + passthruInfo);
                }
                if ((nArray = this.getPassThruSystemsTableSelection()).length >= 1) {
                    int n = nArray[0];
                    this.passThruSystems.set(n, passthruInfo);
                }
                this.updateDataBeanInfo(false);
                this.updateUTMElements();
            }
        } else if (2 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKF, "displayComplete CANCEL path?");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--displayComplete()");
        }
    }

    public Serializable nextButtonHit() throws WizardTaskException {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->nextButtonHit()");
        }
        if (this.passThruSystems.size() < 1) {
            throw new WizardTaskException(new LocalizableText("com.ibm.hsc.common.bundles.ConnectivityText", "NO_PASSTHRU_ENTRY_TITLE", null), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "W", "com.ibm.hsc.common.bundles.GuidedSetupWizardMessages", "0606", null));
        }
        this.connectivityState.savePassThruState(this.getPassThruSystems());
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--nextButtonHit()");
        }
        return this.connectivityState;
    }

    public Serializable backButtonHit() {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "-->backButtonHit()");
        }
        this.connectivityState.savePassThruState(this.getPassThruSystems());
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<--backButtonHit()");
        }
        return this.connectivityState;
    }

    private void updateDataBeanInfo(boolean bl) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-->updateDataBeanInfo(" + bl + ")");
        }
        this.m_idPassThruSystemsTable = new ItemDescriptor[this.passThruSystems.size()][2];
        for (int i = 0; i < this.passThruSystems.size(); ++i) {
            PassthruInfo passthruInfo = (PassthruInfo)this.passThruSystems.get(i);
            String string = passthruInfo.getIpAddress();
            this.m_idPassThruSystemsTable[i][0] = new ItemDescriptor(null, string);
            String string2 = passthruInfo.getDescription();
            this.m_idPassThruSystemsTable[i][1] = new ItemDescriptor(null, string2);
        }
        if (bl && this.passThruSystems.size() >= 1) {
            this.m_iPassThruSystemsTableSelection = new int[]{0};
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--updateDataBeanInfo()");
        }
    }

    private void updateUTMElements() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-->updateUTMElements()");
        }
        if (this.userTaskManager != null) {
            String string = this.getMountPrefix();
            this.userTaskManager.setEnabled(string + "PassThruSystemsGroup", true);
            this.userTaskManager.setEnabled(string + "PassThruSystemsTable", true);
            if (this.passThruSystems.size() < 5) {
                this.userTaskManager.setEnabled(string + "AddButton", true);
            } else {
                this.userTaskManager.setEnabled(string + "AddButton", false);
            }
            if (this.passThruSystems.size() > 0) {
                this.userTaskManager.setEnabled(string + "RemoveButton", true);
                this.userTaskManager.setEnabled(string + "EditButton", true);
            } else {
                this.userTaskManager.setEnabled(string + "RemoveButton", false);
                this.userTaskManager.setEnabled(string + "EditButton", false);
            }
            if (this.passThruSystems.size() > 1) {
                this.userTaskManager.setEnabled(string + "UpButton", true);
                this.userTaskManager.setEnabled(string + "DownButton", true);
            } else {
                this.userTaskManager.setEnabled(string + "UpButton", false);
                this.userTaskManager.setEnabled(string + "DownButton", false);
            }
            this.userTaskManager.refreshElement(string + "PassThruSystemsGroup");
            this.userTaskManager.refreshElement(string + "PassThruSystemsTable");
            this.userTaskManager.refreshElement(string + "AddButton");
            this.userTaskManager.refreshElement(string + "EditButton");
            this.userTaskManager.refreshElement(string + "RemoveButton");
            this.userTaskManager.refreshElement(string + "UpButton");
            this.userTaskManager.refreshElement(string + "DownButton");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<--updateUTMElements()");
        }
    }
}

